jQuery(document).ready(function($) {

    $('.brb-admin-page a.nav-tab').on('click', function(e)  {
        let $this = $(this), activeId = $this.attr('href');
        $(activeId).show().siblings('.tab-content').hide();
        $this.addClass('nav-tab-active').siblings().removeClass('nav-tab-active');
        e.preventDefault();
    });

    var $statsTxt = $('#stats');
    if ($statsTxt.length) {
        let chart = null,
            $months = $('#grw-overview-months'),
            $places = $('#grw-overview-places'),
            $rating  = $('#grw-overview-rating'),
            $stats = $('#grw-overview-stats'),
            $reviews = $('#grw-overview-reviews');

        $months.change(function() {
            ajaxChartRender();
        });

        $places.change(function() {
            ajaxChartRender();
        });

        function ajaxChartRender() {
            //chart.updateOptions({series: [], noData: { text: 'Loading...' }});
            $.post({
                url      : ajaxurl,
                type     : 'POST',
                dataType : 'json',
                data     : {action: 'brb_stats', conn_id: $places.val()},
                success  : function(res) {
                    chartUpdate(res);
                }
            });
        }

        function chartUpdate(json_data) {
            let json = json_data || JSON.parse($statsTxt.val()),

                json_ratings = json.ratings,
                json_reviews_new = json.reviews_new,
                json_reviews_count = json.reviews_count,

                rating = parseFloat(json.grow.rating).toFixed(1),
                review_count = json.grow.total,

                // Stats parameters
                start_using = parseInt(json.grow.date),
                using_period = new Date().getTime() - start_using,

                rating_after = parseFloat(json.grow.after.rating).toFixed(1),
                review_count_after = json.grow.after.total,

                rating_before = parseFloat(json.grow.before.rating).toFixed(1),
                review_count_before = json.grow.total - review_count_after,

                rating_increse = rating_after - rating_before;
                review_count_increse = parseInt((review_count_after * 100) / review_count_before);

            // Calculate stats for specific period
            let now = new Date(),
                period_end = now,
                data_ratings = [],
                data_reviews_new = [],
                data_reviews_count = [];

            period_end.setDate(1);
            period_end.setHours(0);
            period_end.setMinutes(0);
            period_end.setSeconds(0);
            period_end.setMonth(period_end.getMonth() - $months.val());

            for (let i = 0; now.getTime() > period_end.getTime(); i++) {
                now.setMonth(now.getMonth() - i);
            }

            for (let i = 0; i < json_reviews_count.length; i++) {
                if (period_end < new Date(json_reviews_count[i].x)) {
                    data_ratings.push(json_ratings[i]);
                    data_reviews_new.push(json_reviews_new[i]);
                    data_reviews_count.push(json_reviews_count[i]);
                }
            }

            if (chart) {
                chart.data.datasets[0].data = data_ratings;
                chart.data.datasets[1].data = data_reviews_count;
                chart.data.datasets[2].data = data_reviews_new;
                chart.update();
            } else {
                chartRender(data_ratings, data_reviews_new, data_reviews_count);
            }

            /*
             * Render rating
             */
            let $opt = $places.find('option:selected');
            $rating.html(
            '<div class="rpi">' +
                '<div class="rpi-header">' +
                    '<div class="rpi-info">' +
                        '<div class="rpi-name rpi-logo rpi-logo-' + $opt.attr('data-platform') + '">' + $opt.text() + '</div>' +
                        '<div class="rpi-score">' +
                            '<div class="rpi-grade">' + rating + '</div>' +
                            '<div class="rpi-stars">' + RichPlugins.Utils.stars(rating) + '</div>' +
                        '</div>' +
                        '<div class="rpi-based">Based on ' + review_count + ' reviews</div>' +
                        (json.synced ?
                        '<div class="wp-google-powered">Last sync: ' +
                            '<span class="wp-google-time">' +
                                WPacTime.getTime(parseInt(json.synced), _rplg_lang(), 'ago') +
                            '</span>' +
                        '</div>' : '') +
                    '</div>' +
                '</div>' +
            '</div>');

            /*
             * Render stats
             */
            $stats.html(
                '<div>' +
                    'Start using: ' +
                    '<span class="grw-stat-val">' + ms2my(start_using) + '</span>' +
                '</div>' +
                '<div>' +
                    'Usage time: ' +
                    '<span class="grw-stat-val">' + ms2dmy(using_period) + '</span>' +
                '</div>' +
                '<div>' +
                    'Rating received' +
                    '<span class="grw-stat-val grw-stat-' + (rating_after < 0 ? 'down' : (rating_after > 0 ? 'up' : '')) + '">' +
                        rating_after +
                    '</span>' +
                '</div>' +
                '<div>' +
                    'New reviews received' +
                    '<span class="grw-stat-val grw-stat-' + (review_count_after < 0 ? 'down' : (review_count_after > 0 ? 'up' : '')) + '">' +
                        review_count_after +
                    '</span>' +
                '</div>' +
                '<div>' +
                    'Increases reviews by' +
                    '<span class="grw-stat-val grw-stat-' + (review_count_increse < 0 ? 'down' : (review_count_increse > 0 ? 'up' : '')) + '">' +
                        review_count_increse + '%' +
                    '</span>' +
                '</div>');

            /*
             * Render reviews
             */
            let $rpi = $('.rpi'),
                $rpicards = $('.rpi-cards', $rpi),
                Common = RichPlugins.Common($rpi[0], {});

            $rpicards.html('');
            $.each(json.reviews, function(i, rev) {
                let el = document.createElement('div'),
                    rb = document.createElement('span');

                el.className = 'rpi-card';
                rb.innerHTML = 'Reply';
                rb.className = 'rpi-reply-btn';
                rb.onclick = function() {
                    let comment = prompt('Please type your reply', rev.reply);
                    if (comment && comment != rev.reply) {
                        $.post({
                            url      : ajaxurl,
                            type     : 'POST',
                            dataType : 'json',
                            data     : {
                                action  : 'brb_reply',
                                conn_id : $places.val(),
                                rev_id  : rev.id,
                                comment : comment
                            },
                            success  : function(res) {
                                rev.reply = res.comment;
                                Common.reviewReply(el, res.comment);
                                console.log(res);
                            }
                        });
                    }
                };

                Common.convertReviewEl(el, rev);
                el.appendChild(rb);
                $rpicards[0].appendChild(el);
            });
        }

        // TODO HERE

        chartUpdate();
    }

    function ms2my(s) {
        let d = new Date(s),
            m = d.toLocaleString('default', { month: 'short'});
        return m + ' ' + d.getFullYear();
    }

    function ms2dmy(s) {
        let d = (s / (1000 * 60 * 60 * 24)).toFixed(0);
        if (d > 30) {
            if (d > 365) {
                return Math.round(d / 365) + ' years';
            }
            return Math.round(d / 30) + ' months';
        }
        return d + ' days';
    }

});