function rplg_svg() {
    return '' +
    '<svg>' +
        '<defs>' +
            '<g id="rp-star" width="17" height="17">' +
                '<path d="M1728 647q0 22-26 48l-363 354 86 500q1 7 1 20 0 21-10.5 35.5t-30.5 14.5q-19 0-40-12l-449-236-449 236q-22 12-40 12-21 0-31.5-14.5t-10.5-35.5q0-6 2-20l86-500-364-354q-25-27-25-48 0-37 56-46l502-73 225-455q19-41 49-41t49 41l225 455 502 73q56 9 56 46z"></path>' +
            '</g>' +
            '<g id="rp-star-half" width="17" height="17">' +
                '<path d="M1250 957l257-250-356-52-66-10-30-60-159-322v963l59 31 318 168-60-355-12-66zm452-262l-363 354 86 500q5 33-6 51.5t-34 18.5q-17 0-40-12l-449-236-449 236q-23 12-40 12-23 0-34-18.5t-6-51.5l86-500-364-354q-32-32-23-59.5t54-34.5l502-73 225-455q20-41 49-41 28 0 49 41l225 455 502 73q45 7 54 34.5t-24 59.5z"></path>' +
            '</g>' +
            '<g id="rp-star-o" width="17" height="17">' +
                '<path d="M1201 1004l306-297-422-62-189-382-189 382-422 62 306 297-73 421 378-199 377 199zm527-357q0 22-26 48l-363 354 86 500q1 7 1 20 0 50-41 50-19 0-40-12l-449-236-449 236q-22 12-40 12-21 0-31.5-14.5t-10.5-35.5q0-6 2-20l86-500-364-354q-25-27-25-48 0-37 56-46l502-73 225-455q19-41 49-41t49 41l225 455 502 73q56 9 56 46z" fill="#ccc"></path>' +
            '</g>' +
            '<g id="rp-logo-g" height="44" width="44" fill="none" fill-rule="evenodd">' +
                '<path d="M482.56 261.36c0-16.73-1.5-32.83-4.29-48.27H256v91.29h127.01c-5.47 29.5-22.1 54.49-47.09 71.23v59.21h76.27c44.63-41.09 70.37-101.59 70.37-173.46z" fill="#4285f4"></path><path d="M256 492c63.72 0 117.14-21.13 156.19-57.18l-76.27-59.21c-21.13 14.16-48.17 22.53-79.92 22.53-61.47 0-113.49-41.51-132.05-97.3H45.1v61.15c38.83 77.13 118.64 130.01 210.9 130.01z" fill="#34a853"></path><path d="M123.95 300.84c-4.72-14.16-7.4-29.29-7.4-44.84s2.68-30.68 7.4-44.84V150.01H45.1C29.12 181.87 20 217.92 20 256c0 38.08 9.12 74.13 25.1 105.99l78.85-61.15z" fill="#fbbc05"></path><path d="M256 113.86c34.65 0 65.76 11.91 90.22 35.29l67.69-67.69C373.03 43.39 319.61 20 256 20c-92.25 0-172.07 52.89-210.9 130.01l78.85 61.15c18.56-55.78 70.59-97.3 132.05-97.3z" fill="#ea4335"></path><path d="M20 20h472v472H20V20z"></path>' +
            '</g>' +
            '<g id="rp-logo-f" width="30" height="30" transform="translate(23,85) scale(0.05,-0.05)">' +
                '<path fill="#fff" d="M959 1524v-264h-157q-86 0 -116 -36t-30 -108v-189h293l-39 -296h-254v-759h-306v759h-255v296h255v218q0 186 104 288.5t277 102.5q147 0 228 -12z"></path>' +
            '</g>' +
            '<g id="rp-logo-y" x="0px" y="0px" width="44" height="44" style="enable-background:new 0 0 533.33 533.33;" xml:space="preserve">' +
                '<path d="M317.119,340.347c-9.001,9.076-1.39,25.586-1.39,25.586l67.757,113.135c0,0,11.124,14.915,20.762,14.915   c9.683,0,19.246-7.952,19.246-7.952l53.567-76.567c0,0,5.395-9.658,5.52-18.12c0.193-12.034-17.947-15.33-17.947-15.33   l-126.816-40.726C337.815,335.292,325.39,331.994,317.119,340.347z M310.69,283.325c6.489,11.004,24.389,7.798,24.389,7.798   l126.532-36.982c0,0,17.242-7.014,19.704-16.363c2.415-9.352-2.845-20.637-2.845-20.637l-60.468-71.225   c0,0-5.24-9.006-16.113-9.912c-11.989-1.021-19.366,13.489-19.366,13.489l-71.494,112.505   C311.029,261.999,304.709,273.203,310.69,283.325z M250.91,239.461c14.9-3.668,17.265-25.314,17.265-25.314l-1.013-180.14   c0,0-2.247-22.222-12.232-28.246c-15.661-9.501-20.303-4.541-24.79-3.876l-105.05,39.033c0,0-10.288,3.404-15.646,11.988   c-7.651,12.163,7.775,29.972,7.775,29.972l109.189,148.831C226.407,231.708,237.184,242.852,250.91,239.461z M224.967,312.363   c0.376-13.894-16.682-22.239-16.682-22.239L95.37,233.079c0,0-16.732-6.899-24.855-2.091c-6.224,3.677-11.738,10.333-12.277,16.216   l-7.354,90.528c0,0-1.103,15.685,2.963,22.821c5.758,10.128,24.703,3.074,24.703,3.074L210.37,334.49   C215.491,331.048,224.471,330.739,224.967,312.363z M257.746,361.219c-11.315-5.811-24.856,6.224-24.856,6.224l-88.265,97.17   c0,0-11.012,14.858-8.212,23.982c2.639,8.552,7.007,12.802,13.187,15.797l88.642,27.982c0,0,10.747,2.231,18.884-0.127   c11.552-3.349,9.424-21.433,9.424-21.433l2.003-131.563C268.552,379.253,268.101,366.579,257.746,361.219z" fill="#D80027"/>' +
            '</g>' +
            '<g id="rp-dots" fill="none" fill-rule="evenodd" width="12" height="12">' +
                '<circle cx="6" cy="3" r="1" fill="#000"/>' +
                '<circle cx="6" cy="6" r="1" fill="#000"/>' +
                '<circle cx="6" cy="9" r="1" fill="#000"/>' +
            '</g>' +
        '</defs>' +
    '</svg>';
}

function simple_star(star, color, bg_color) {
    return '<svg viewBox="0 0 1792 1792" width="17" height="17" ' + (bg_color ? 'style="background:' + bg_color + '"' : '') + '>' +
               '<use xlink:href="#rp-star' + star + '" fill="' + color + '"/>' +
           '</svg>';
}

function simple_stars(rating, color) {
    var str = '';
    for (var i = 1; i < 6; i++) {
        var score = rating - i;
        if (score >= 0) {
            str += simple_star('', color);
        } else if (score > -1 && score < 0) {
            if (score < -0.75) {
                str += simple_star('-o', color);
            } else if (score > -0.25) {
                str += simple_star('', color);
            } else {
                str += simple_star('-half', color);
            }
        } else {
            str += simple_star('-o', color);
        }
    }
    return str;
}

function yelp_stars(rating, color, bg_color) {
    var stars = '';
    for (let i = 0; i < 5; i++) {
        let bg = rating - i >= 1 ? bg_color : (rating - i > 0 ? 'linear-gradient(90deg, ' + bg_color + ' 50%, #bbbac0 50%)' : '');
        stars += simple_star('', color, bg);
    }
    return stars;
}

function render_stars(rating, provider, color) {
    switch (provider) {
        case 'google'   : return simple_stars(rating, color || '#fb8e28');
        case 'facebook' : return simple_stars(rating, color || '#3c5b9b');
        case 'yelp'     : return yelp_stars(rating, '#ffffff', color);

    }
    return simple_stars(rating, color || '#fb8e28');
}

function render_logo(provider) {
    switch (provider) {
        case 'google'   : return '<svg viewBox="0 0 512 512" width="44" height="44"><use xlink:href="#rp-logo-g"/></svg>';
        case 'facebook' : return '<svg viewBox="0 0 100 100" width="44" height="44" data-provider="f"><use xlink:href="#rp-logo-f"/></svg>';
        case 'yelp'     : return '<svg viewBox="0 0 533.33 533.33" width="44" height="44"><use xlink:href="#rp-logo-y"/></svg>';
    }
}

function render_rplg_logo(provider) {
    if (provider == 'summary') return '';
    else return '<span class="rplg-social-logo rplg-' + provider + '-logo">' + render_logo(provider) + '</span>';
}

function _rplg_add_svg() {
    var span = document.getElementById('rplg-svg');
    if (!span) {
        span = document.createElement('span');
        span.id = 'rplg-svg';
        span.style.display = 'none';
        span.innerHTML = rplg_svg();
        document.body.appendChild(span);
    }
}

function _rplg_init_svg(el) {
    _rplg_add_svg();

    var stars = el.querySelectorAll('.rplg-stars');
    for (var i = 0; i < stars.length; i++) {
        var info = stars[i].getAttribute('data-info'),
            infos = info.split(','),
            rating = infos[0],
            provider = infos[1],
            color = infos[2];

        stars[i].innerHTML = render_stars(rating, provider, color);
    }

    var badges = el.querySelectorAll('.rplg [data-badge]');
    for (var i = 0; i < badges.length; i++) {
        badges[i].innerHTML = render_rplg_logo(badges[i].getAttribute('data-badge'));
    }

    var logos = el.querySelectorAll('.rplg [data-logo]');
    for (var i = 0; i < logos.length; i++) {
        logos[i].innerHTML = render_logo(logos[i].getAttribute('data-logo'));
    }
}

function _rplg_badge_init(el) {
    var badge_cnt = el.querySelector('.rplg-badge-cnt'),
        is_float = badge_cnt.className.indexOf('-fixed') > -1;
    if (is_float) {
        document.body.appendChild(el);
    }

    var badges = el.querySelectorAll('.rplg-badge2'),
        rplg   = document.createElement('div');

    for (var i = 0; i < badges.length; i++) {
        var badge     = badges[i],
            provider  = badge.getAttribute('data-provider'),
            badge_key = 'badge_float_' + provider,
            session   = sessionStorage.getItem(badge_key),
            logo      = badge.querySelector('.rplg-badge-logo'),
            btn       = badge.querySelector('.rplg-badge2-btn'),
            close     = badge.querySelector('.rplg-badge2-close'),
            form      = badge.querySelector('.rplg-form');
        (function(badge, badge_key, session, provider, logo, btn, close, form) {
            if (is_float) {
                badge.style.display='block';
            }
            if (close) {
                if (session) {
                    var data = JSON.parse(session);
                    if (data.hide) {
                        badge.style.display='none';
                    }
                }
                close.onclick = function() {
                    badge.style.display='none';
                    var value = JSON.parse(sessionStorage.getItem(badge_key) || '{}');
                    value.hide = true;
                    sessionStorage.setItem(badge_key, JSON.stringify(value));
                };
            }
            if (logo && provider != 'summary') {
                if (!logo.querySelector('img')) {
                    logo.innerHTML = render_logo(provider);
                }
            }
            if (form) {
                btn.onclick = function() {
                    rplg_load_imgs(form);
                    form.style.display='block';
                };
                rplg.appendChild(form);
                let wr = form.querySelector('.wp-google-wr');
                if (wr.hasChildNodes()) {
                    form.setAttribute('data-btn', '1');
                }

            }
        })(badge, badge_key, session, provider, logo, btn, close, form);
    }

    if (rplg.hasChildNodes()) {
        rplg.className = 'rplg';
        document.body.appendChild(rplg);
    }
}

function rplg_load_imgs(el) {
    var imgs = el.querySelectorAll('img.rplg-blazy[data-src]');
    for (var i = 0; i < imgs.length; i++) {
        imgs[i].setAttribute('src', imgs[i].getAttribute('data-src'));
        imgs[i].removeAttribute('data-src');
    }
}

function rplg_next_reviews(pagin) {
    var parent = this.parentNode,
        selector = '.rplg .rplg-hide';
        reviews = parent.querySelectorAll(selector);
    for (var i = 0; i < pagin && i < reviews.length; i++) {
        if (reviews[i]) {
            reviews[i].className = reviews[i].className.replace('rplg-hide', '');
        }
    }
    reviews = parent.querySelectorAll(selector);
    if (reviews.length < 1) {
        parent.removeChild(this);
    }
    window.rplg_blazy && window.rplg_blazy.revalidate();
    return false;
}

function rplg_leave_review_window() {
    _rplg_popup(this.getAttribute('href'), 620, 500);
    return false;
}

function _rplg_lang() {
    var n = navigator;
    return (n.language || n.systemLanguage || n.userLanguage ||  'en').substr(0, 2).toLowerCase();
}

function _rplg_popup(url, width, height) {
    var dual_left = window.screenLeft != undefined ? window.screenLeft : window.screenX,
        dual_top = window.screenTop != undefined ? window.screenTop : window.screenY,

        doc_elem = document.documentElement,
        screen_width = window.innerWidth ? window.innerWidth : doc_elem.clientWidth ? doc_elem.clientWidth : screen.width,
        screen_height = window.innerHeight ? window.innerHeight : doc_elem.clientHeight ? doc_elem.clientHeight : screen.height,

        left = ((screen_width / 2) - (width / 2)) + dual_left,
        top = ((screen_height / 2) - (height / 2)) + dual_top,
        win = window.open(url, '', 'scrollbars=yes, width=' + width + ', height=' + height + ', top=' + top + ', left=' + left);

    if (window.focus) {
        win.focus();
    }

    return win;
}

function _rplg_init_timeago(el) {
    var els = el.querySelectorAll('.rplg [data-time]');
    for (var i = 0; i < els.length; i++) {
        var clss = els[i].className, time;
        time = parseInt(els[i].getAttribute('data-time')) * 1000;
        els[i].innerHTML = WPacTime.getTime(time, _rplg_lang(), 'ago');
    }
}

function _rplg_init_blazy(attempts) {
    if (!window.Blazy) {
        if (attempts > 0) {
            setTimeout(function() { _rplg_init_blazy(attempts - 1); }, 200);
        }
        return;
    }
    window.rplg_blazy = new Blazy({selector: 'img.rplg-blazy'});
}

function _rplg_read_more(el) {
    var read_more = el.querySelectorAll('.rplg-more-toggle');
    for (var i = 0; i < read_more.length; i++) {
        (function(rm) {
        rm.onclick = function() {
            rm.parentNode.removeChild(rm.previousSibling.previousSibling);
            rm.previousSibling.className = '';
            rm.textContent = '';
        };
        })(read_more[i]);
    }
}

function _rplg_init_slider(el, data) {
    if (!window.Rplgsw) {
        return setTimeout(function() { _rplg_init_slider(el, data); }, 200);
    }
    var swiperEl = el.querySelector('.rplgsw-container'),
        swiperData = {
            loop                : true,
            autoplay            : parseInt(data.speed),
            effect              : data.effect,
            slidesPerView       : parseInt(data.count),
            spaceBetween        : parseInt(data.space),
            autoHeight          : true,
            fade                : { crossFade : true },
            breakpoints         : {},
            onInit              : function(swiper) {
                setTimeout(function() {
                    window.dispatchEvent(new Event('resize'));
                }, 500);
            },
            onTransitionEnd     : function(swiper){
                window.rplg_blazy && window.rplg_blazy.revalidate();
            }
        };

    if (data.pagin) {
        swiperData.paginationClickable = true;
        swiperData.pagination = '.rplgsw-pagination';
    }
    if (data.nextprev) {
        swiperData.nextButton = el.querySelector('.rplg-slider-next');
        swiperData.prevButton = el.querySelector('.rplg-slider-prev');
    }
    swiperData.breakpoints[data.mobileBreakpoint] = {
        slidesPerView: parseInt(data.mobileCount),
        spaceBetween: 10
    };
    swiperData.breakpoints[data.tabletBreakpoint] = {
        slidesPerView: parseInt(data.tabletCount),
        spaceBetween: 20
    };
    swiperData.breakpoints[data.desktopBreakpoint] = {
        slidesPerView: parseInt(data.desktopCount),
        spaceBetween: 30
    };
    return new Rplgsw(swiperEl, swiperData);
}

function _rplg_init_sliderlite(el, data) {
    const SLIDER_ELEM  = el.querySelector('.grw-slider'),
          SLIDER_SPEED = data.speed * 1000,
          REVIEWS_ELEM = el.querySelector('.grw-slider-reviews'),
          REVIEW_ELEMS = el.querySelectorAll('.grw-slider-review');

    var resizeTimout = null,
        swipeTimout = null;

    var init = function() {
        if (isVisible(SLIDER_ELEM)) {
            resize();
            _rplg_init_blazy(10);
            if (REVIEW_ELEMS.length) {
                setTimeout(swipe, SLIDER_SPEED);
            }
        } else {
            setTimeout(init, 300);
        }
    }
    init();

    window.addEventListener('resize', function() {
        clearTimeout(resizeTimout);
        resizeTimout = setTimeout(function() { resize(); }, 150);
    });

    REVIEWS_ELEM.addEventListener('scroll', function() {
        setTimeout(dotsinit, 200);
        if (window.rplg_blazy) {
            window.rplg_blazy.revalidate();
        }
    });

    function resize() {
        var row_elem = el.querySelector('.grw-slider .grw-row');
        if (row_elem.offsetWidth < 510) {
            row_elem.className = 'grw-row grw-row-xs';
        } else if (row_elem.offsetWidth < 750) {
            row_elem.className = 'grw-row grw-row-x';
        } else if (row_elem.offsetWidth < 1100) {
            row_elem.className = 'grw-row grw-row-s';
        } else if (row_elem.offsetWidth < 1450) {
            row_elem.className = 'grw-row grw-row-m';
        } else if (row_elem.offsetWidth < 1800) {
            row_elem.className = 'grw-row grw-row-l';
        } else {
            row_elem.className = 'grw-row grw-row-xl';
        }
        if (REVIEW_ELEMS.length) {
            setTimeout(dotsinit, 200);
        }
    }

    function dotsinit() {
        var reviews_elem = el.querySelector('.grw-slider-reviews'),
            review_elems = el.querySelectorAll('.grw-slider-review'),
            t = review_elems.length,
            v = Math.round(reviews_elem.offsetWidth / review_elems[0].offsetWidth);

        var dots = Math.ceil(t/v),
            dotscnt = el.querySelector('.grw-slider-dots');

        if (!dotscnt) return;

        dotscnt.innerHTML = '';
        for (var i = 0; i < dots; i++) {
            var dot = document.createElement('div');
            dot.className = 'grw-slider-dot';

            var revWidth = review_elems[0].offsetWidth;
            var center = (reviews_elem.scrollLeft + (reviews_elem.scrollLeft + revWidth * v)) / 2;

            x = Math.ceil((center * dots) / reviews_elem.scrollWidth);
            if (x == i + 1) dot.className = 'grw-slider-dot active';

            dot.setAttribute('data-index', i + 1);
            dot.setAttribute('data-visible', v);
            dotscnt.appendChild(dot);

            dot.onclick = function() {
                var curdot = el.querySelector('.grw-slider-dot.active'),
                    ii = parseInt(curdot.getAttribute('data-index')),
                    i = parseInt(this.getAttribute('data-index')),
                    v = parseInt(this.getAttribute('data-visible'));

                if (ii < i) {
                    scrollNext(v * Math.abs(i - ii));
                } else {
                    scrollPrev(v * Math.abs(i - ii));
                }

                el.querySelector('.grw-slider-dot.active').className = 'grw-slider-dot';
                this.className = 'grw-slider-dot active';

                if (swipeTimout) {
                    clearInterval(swipeTimout);
                }
            };
        }
    }

    function isVisible(elem) {
        return !!(elem.offsetWidth || elem.offsetHeight || elem.getClientRects().length) && window.getComputedStyle(elem).visibility !== 'hidden';
    }

    function isVisibleInParent(elem) {
        var elemRect = elem.getBoundingClientRect(),
            parentRect = elem.parentNode.getBoundingClientRect();

        return (Math.abs(parentRect.left - elemRect.left) < 2 || parentRect.left <= elemRect.left) && elemRect.left < parentRect.right &&
               (Math.abs(parentRect.right - elemRect.right) < 2 || parentRect.right >= elemRect.right) && elemRect.right > parentRect.left;
    }

    function scrollPrev(offset) {
        REVIEWS_ELEM.scrollBy(
            -REVIEW_ELEMS[0].offsetWidth * offset, 0
        );
    }

    function scrollNext(offset) {
        REVIEWS_ELEM.scrollBy(
            REVIEW_ELEMS[0].offsetWidth * offset, 0
        );
    }

    var prev = el.querySelector('.grw-slider-prev');
    if (prev) {
        prev.onclick = function() {
            scrollPrev(1);
            if (swipeTimout) {
                clearInterval(swipeTimout);
            }
        };
    }

    var next = el.querySelector('.grw-slider-next');
    if (next) {
        next.onclick = function() {
            scrollNext(1);
            if (swipeTimout) {
                clearInterval(swipeTimout);
            }
        };
    }

    function swipe() {
        if (isVisibleInParent(el.querySelector('.grw-slider-review:last-child'))) {
            REVIEWS_ELEM.scrollBy(-REVIEWS_ELEM.scrollWidth, 0);
        } else {
            scrollNext(1);
        }
        swipeTimout = setTimeout(swipe, SLIDER_SPEED);
    }
}

function _rplg_init_flash(el, opts) {
    var xkey = 'flash_' + el.getAttribute('data-id'),
        session = sessionStorage.getItem(xkey);

    if (session) {
        return;
    }

    var i         = 0,
        expanded  = false,
        wait      = false,
        reviews   = [],
        cnt       = el.querySelector('.rplg-flash-content'),
        x         = cnt.querySelector('.rplg-flash-x'),
        card      = cnt.querySelector('.rplg-flash-card'),
        story     = cnt.querySelector('.rplg-flash-story'),
        start     = (opts.flash_start || 3) * 1000,
        visible   = (opts.flash_visible || 5) * 1000,
        invisible = (opts.flash_invisible || 5) * 1000,
        showtimer = null,

        rplgIsHover = e => e.parentElement.querySelector(':hover') === e;

    document.body.appendChild(el);

    var revels = el.querySelectorAll('.rplg-form-review');
    for (var j = 0; j < revels.length; j++) {
        var revel = revels[j],
            infos = revel.querySelector('.rplg-stars').getAttribute('data-info').split(',');

        var time;
        if (opts.disable_review_time) {
            time = '';
        } else {
            var timeEl = revel.querySelector('.rplg-review-time');
            time = opts.time_format ? timeEl.innerText : timeEl.getAttribute('data-time');
        }

        reviews.push({
            avatar      : opts.hide_avatar ? '' : revel.querySelector('.rplg-review-avatar').getAttribute(opts.lazy_load_img ? 'data-src' : 'src'),
            author_name : opts.hide_name   ? '' : revel.querySelector('.rplg-review-name').getAttribute('title'),
            time        : time,
            rating      : infos[0],
            provider    : infos[1]
        });
    }

    var show = function(nonext) {
        if (!expanded && !wait) {
            _rplg_flashnext(el, story, i, reviews, opts);
            cnt.className = 'rplg-flash-content rplg-flash-visible';
            i = i + 1 < reviews.length ? i + 1 : 0;
        }
        wait = false;
        showtimer = setTimeout(function() {
            if (!expanded && !rplgIsHover(cnt) && !wait) {
                cnt.className = 'rplg-flash-content';
            }
            showtimer = setTimeout(show, invisible);
        }, visible);
    };
    setTimeout(show, start);

    var hide = function() {
        var val = JSON.parse(sessionStorage.getItem(xkey) || '{}');
        val.hide = true;
        sessionStorage.setItem(xkey, JSON.stringify(val));
        clearTimeout(showtimer);
        cnt.className = 'rplg-flash-content';
    };
    x.onclick = hide;

    story.onclick = function() {
        expanded = true;
        rplg_load_imgs(cnt);

        var idx = card.querySelector('.rplg-row').getAttribute('data-idx'),
            review = card.querySelector('.rplg-form-review[data-idx="' + idx + '"]');

        review.className = 'rplg-form-review rplg-highlight';
        setTimeout(function() { review.scrollIntoView({behavior: 'smooth', block: 'center'}) }, 300);

        card.className = 'rplg-flash-card rplg-flash-expanded';
        cnt.className = 'rplg-flash-content rplg-flash-visible';
        x.innerHTML = '<svg viewBox="0 0 86.001 86.001"><path style="fill:#030104" d="M5.907,21.004c-1.352-1.338-3.542-1.338-4.894,0c-1.35,1.336-1.352,3.506,0,4.844l39.54,39.15   c1.352,1.338,3.542,1.338,4.894,0l39.54-39.15c1.351-1.338,1.352-3.506,0-4.844c-1.352-1.338-3.542-1.338-4.894-0.002L43,56.707   L5.907,21.004z"></path></svg>';
        x.onclick = function() {
            review.className = 'rplg-form-review';
            card.className = 'rplg-flash-card';
            expanded = false;
            wait = true;
            x.innerHTML = '×';
            x.onclick = hide;
        };
    };
}

function _rplg_flashnext(el, story, i, reviews, opts) {
    if (story.firstChild) {
        var review = reviews[i];
        story.querySelector('.rplg-row').setAttribute('data-idx', i);
        if (opts.flash_user_photo) {
            story.querySelector('.rplg-flash-img').innerHTML = '<img src="' + review.avatar + '" class="rplg-review-avatar" ' +
                                                                     'alt="' + review.author_name + '" width="44" height="44">';
        } else if (!opts.hide_avatar) {
            story.querySelector('.rplg-flash-photo').innerHTML = '<img src="' + review.avatar + '" class="rplg-review-avatar" ' +
                                                                       'alt="' + review.author_name + '" width="16" height="16">';
        }
        if (!opts.hide_name) {
            story.querySelector('.rplg-flash-name').innerHTML = review.author_name;
        }
        story.querySelector('.rplg-flash-rating').innerHTML = parseInt(review.rating);
        story.querySelector('.rplg-flash-stars').innerHTML = _rplg_flashtext(review, opts);
        if (!opts.disable_review_time) {
            story.querySelector('.rplg-flash-time').innerHTML = opts.time_format ?
                                                                review.time : WPacTime.getTimeAgo(review.time * 1000, _rplg_lang(), 'ago');
        }
    } else {
        story.innerHTML = _rplg_flashstory(i, reviews, opts);
    }
}

function _rplg_flashstory(i, reviews, opts) {
    var review = reviews[i];
    return '<div class="rplg-row" data-idx="' + i + '">' +

               (opts.flash_hide_logo && !opts.flash_user_photo ? '' :
               '<div class="rplg-row-left">' +
                   '<div class="rplg-flash-img">' +

                       (opts.flash_user_photo ?

                       '<img src="' + review.avatar + '" class="rplg-review-avatar" alt="' + review.author_name + '" width="44" height="44">' :

                       '<span style="position:relative;display:inline-block;margin:0 6px 0 0;vertical-align: middle;"><svg viewBox="0 0 1792 1792" width="44" height="44"><path d="M1728 647q0 22-26 48l-363 354 86 500q1 7 1 20 0 21-10.5 35.5t-30.5 14.5q-19 0-40-12l-449-236-449 236q-22 12-40 12-21 0-31.5-14.5t-10.5-35.5q0-6 2-20l86-500-364-354q-25-27-25-48 0-37 56-46l502-73 225-455q19-41 49-41t49 41l225 455 502 73q56 9 56 46z" fill="#FFAF02"></path></svg><span style="position:absolute;bottom:0px;right:0px;width:26px;height:26px;background:#fff;border-radius:50%;border:4px solid #212121"></span><svg width="25" height="25" viewBox="0 0 1792 1792" style="position:absolute;bottom:0;right:0;border-radius:50%;background:#fff"><path d="M1299 813l-422 422q-19 19-45 19t-45-19l-294-294q-19-19-19-45t19-45l102-102q19-19 45-19t45 19l147 147 275-275q19-19 45-19t45 19l102 102q19 19 19 45t-19 45zm141 83q0-148-73-273t-198-198-273-73-273 73-198 198-73 273 73 273 198 198 273 73 273-73 198-198 73-273zm224 0q0 209-103 385.5t-279.5 279.5-385.5 103-385.5-103-279.5-279.5-103-385.5 103-385.5 279.5-279.5 385.5-103 385.5 103 279.5 279.5 103 385.5z" fill="#8cc976"></path></svg></span>') +

                   '</div>' +
               '</div>') +

               '<div class="rplg-row-right">' +
                   '<div class="rplg-flash-text">' +

                       (opts.flash_user_photo || opts.hide_avatar ? '' :
                       '<span class="rplg-flash-photo">' +
                           '<img src="' + review.avatar + '" class="rplg-review-avatar" alt="' + review.author_name + '" width="16" height="16">' +
                       '</span>') +

                       (opts.hide_name ? '' :
                       '<span class="rplg-flash-name">' + review.author_name + '</span> ') +

                       '<span> ' + opts.text.m1.replace('%s', '<span class="rplg-flash-rating">' + review.rating + '</span>') + '</span>' +
                   '</div>' +
                   '<div class="rplg-flash-stars">' + _rplg_flashtext(review, opts) + '</div>' +
                   '<div class="rplg-flash-footer">' +

                       (opts.disable_review_time ? '' :
                       '<span class="rplg-flash-time">' +
                           (opts.time_format ? review.time : WPacTime.getTimeAgo(review.time * 1000, _rplg_lang(), 'ago')) +
                       '</span>') +

                       '<span class="rplg-flash-power"></span>' +
                   '</div>' +
               '</div>' +
           '</div>';
}

function _rplg_flashtext(review, opts) {
    var info = [review.rating, review.provider, '#ffa318'].join(',');
    return '<span class="rplg-flash-star rplg-stars" data-provider="' + review.provider + '" data-info="' + info + '">' +
               render_stars(review.rating, review.provider) +
           '</span> ' + opts.text.m2 +
           ' <span class="rplg-flash-logo" data-provider="' + review.provider + '">' +
               render_logo(review.provider) +
           '</span>';
}

function _rplg_get_parent(el, cl) {
    cl = cl || 'rplg';
    if (el.className.split(' ').indexOf(cl) < 0) {
        // the last semicolon (;) without braces ({}) in empty loop makes error in WP Faster Cache
        //while ((el = el.parentElement) && el.className.split(' ').indexOf(cl) < 0);
        while ((el = el.parentElement) && el.className.split(' ').indexOf(cl) < 0){}
    }
    return el;
}

function rplg_init(el, cb) {
    var el = _rplg_get_parent(el, 'rplg'),
        img = el.querySelector('img[data-exec]');

    if (img.getAttribute('data-exec') == 'true') return el;

    _rplg_init_svg(el);
    _rplg_init_timeago(el);
    _rplg_read_more(el);
    if (cb) cb(el);
    _rplg_init_blazy(10);

    img.setAttribute('data-exec', 'true');
    return el;
}

function rplg_init_slider_theme(el, data) {
    rplg_init(el, function(el) {
        _rplg_init_slider(el, data);
    });
}

function rplg_init_sliderlite_theme(el, data) {
    rplg_init(el, function(el) {
        _rplg_init_sliderlite(el, data);
    });
}

function rplg_init_grid_theme(el) {
    rplg_init(el);
}

function rplg_init_list_theme(el) {
    rplg_init(el);
}

function rplg_init_badge_theme(el) {
    rplg_init(el, function(el) {
        _rplg_badge_init(el);
    });
}

function rplg_init_temp_theme(el) {
    rplg_init(el);
}

function rplg_init_flash_theme(el, opts) {
    rplg_init(el, function(el) {
        _rplg_init_flash(el, opts);
    });
}

document.addEventListener('DOMContentLoaded', function() {
    var rplgimgs = document.querySelectorAll('.rplg img[data-exec="false"]');
    for (var i = 0; i < rplgimgs.length; i++) {
        (function(rplgimg) {

            if (rplgimg.getAttribute('data-exec') == 'false') {
                var func = rplgimg.getAttribute('data-func'),
                    args = rplgimg.getAttribute('data-args');

                args = args ? JSON.parse(args) : args;
                window[func](rplgimg.parentNode, args);
            }

        })(rplgimgs[i]);
    }
});