<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       dwd-custom-fullwidth-header-extended
 * @since      1.0.0
 *
 * @package    Dwd_Custom_Fullwidth_Header_Extended
 * @subpackage Dwd_Custom_Fullwidth_Header_Extended/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    Dwd_Custom_Fullwidth_Header_Extended
 * @subpackage Dwd_Custom_Fullwidth_Header_Extended/includes
 * @author     Divi Web Design <hello@diviwebdesign.com>
 */
class Dwd_Custom_Fullwidth_Header_Extended_i18n {


	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.0.0
	 */
	public function load_plugin_textdomain() {

		load_plugin_textdomain(
			'dwd-custom-fullwidth-header-extended',
			false,
			dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
		);

	}



}
