<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              dwd-custom-fullwidth-header-extended
 * @since             1.0.0
 * @package           Dwd_Custom_Fullwidth_Header_Extended
 *
 * @wordpress-plugin
 * Plugin Name:       Divi Custom Fullwidth Header Extended
 * Plugin URI:        https://diviwebdesign.com/
 * Description:       A Custom Fullwidth Header for Divi Builder. Start building and impress your visitors with title effects, background effects, animation and more!
 * Version:           2.1.6
 * Author:            Divi Web Design
 * Author URI:        https://diviwebdesign.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       dwd-custom-fullwidth-header-extended
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-dwd-custom-fullwidth-header-extended-activator.php
 */
function activate_dwd_custom_fullwidth_header_extended() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-dwd-custom-fullwidth-header-extended-activator.php';
	Dwd_Custom_Fullwidth_Header_Extended_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-dwd-custom-fullwidth-header-extended-deactivator.php
 */
function deactivate_dwd_custom_fullwidth_header_extended() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-dwd-custom-fullwidth-header-extended-deactivator.php';
	Dwd_Custom_Fullwidth_Header_Extended_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_dwd_custom_fullwidth_header_extended' );
register_deactivation_hook( __FILE__, 'deactivate_dwd_custom_fullwidth_header_extended' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-dwd-custom-fullwidth-header-extended.php';
include_once ( ABSPATH . 'wp-admin/includes/plugin.php' );
/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_dwd_custom_fullwidth_header_extended() {

	$plugin = new Dwd_Custom_Fullwidth_Header_Extended();
	$plugin->run();

}
run_dwd_custom_fullwidth_header_extended();

$fhe_activated = get_option( 'fhe_license_key_activated' );

function remove_dwd_fhe_update_notifications( $value ) {
    if ( isset( $value ) && is_object( $value ) ) {
        unset( $value->response[ 'dwd-custom-fullwidth-header-extended/load-fullwidth-header-extended.php' ] );
    }
    return $value;
}

if ( empty( $lic )) {
    function dwd_fhe_license_notice() {
        if ( ! FHEPAnD::is_admin_notice_active( 'fhe-disable-done-notice-forever' ) ) {
            return;
        }

        $class = 'notice notice-info is-dismissible';
        $message = __( 'Please enter your Fullwidth Header Extended Module plugin license key to get regular update and support by Navigating to Settings -> Divi Extended. You were given a license key when you purchased this item.', 'dwd-fhe' );

        printf( '<div data-dismissible="fhe-disable-done-notice-forever" class="%1$s"><p>%2$s</p></div>', $class, $message );
    }
    add_action( 'admin_notices', 'dwd_fhe_license_notice' );
}
add_action( 'admin_init', array( 'FHEPAnD', 'init' ) );

if ( $fhe_activated == 'activated' ) {
    $myUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
       'https://diviwebdesign.com/'.$licpath.'fhe.json',
        __FILE__,
        'dwd-custom-fullwidth-header-extended'
    );
} else {
    add_filter( 'site_transient_update_plugins', 'remove_dwd_fhe_update_notifications' );
}
