<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       dwd-custom-fullwidth-header-extended
 * @since      1.0.0
 *
 * @package    Dwd_Custom_Fullwidth_Header_Extended
 * @subpackage Dwd_Custom_Fullwidth_Header_Extended/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Dwd_Custom_Fullwidth_Header_Extended
 * @subpackage Dwd_Custom_Fullwidth_Header_Extended/public
 * @author     Divi Web Design <hello@diviwebdesign.com>
 */
class Dwd_Custom_Fullwidth_Header_Extended_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Dwd_Custom_Fullwidth_Header_Extended_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Dwd_Custom_Fullwidth_Header_Extended_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/dwd-fullwidth-header.css', array(), $this->version, 'all' );
		wp_enqueue_style( 'dwd-animate', plugin_dir_url( __FILE__ ) . 'css/animate.css');
    	wp_register_style( 'dwd-hover-button', plugin_dir_url( __FILE__ ) . 'css/hover.css' );
	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Dwd_Custom_Fullwidth_Header_Extended_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Dwd_Custom_Fullwidth_Header_Extended_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
		wp_enqueue_script('dwd-fhe-custom', plugin_dir_url( __FILE__ ) . 'js/dwd-fhe-custom.js', array( 'jquery' ), $this->version, true );
		wp_register_script('dwd-animation-load', plugin_dir_url( __FILE__ ) . 'js/animation-load.js', array('jquery'), '1.0', true);
	    wp_register_script('dwd-typed', plugin_dir_url( __FILE__ ) . 'js/typed.js', array('jquery'), null, false);
	    wp_register_script('dwd-typed-script', plugin_dir_url( __FILE__ ) . 'js/dwd-typing.js', array('jquery'), null, false);
	    wp_register_script('dwd-lettering', plugin_dir_url( __FILE__ ) . 'js/jquery.lettering.js', array('jquery'), null, true);
	    wp_register_script('dwd-textillate', plugin_dir_url( __FILE__ ) . 'js/jquery.textillate.js', array('dwd-lettering'), null, true);
	    wp_register_script('dwd-textillate-start', plugin_dir_url( __FILE__ ) . 'js/textillate-start.js', array('dwd-textillate'), null, true);
	    wp_register_script('dwd-morptext', plugin_dir_url( __FILE__ ) . 'js/morphext.min.js', array('jquery'), null, false);
	    wp_register_script('dwd-textrotator', plugin_dir_url( __FILE__ ) . 'js/textrotator.js', array('dwd-morptext'), '1.0', false);
	    wp_register_script('dwd-particles', plugin_dir_url( __FILE__ ) . 'js/particles.min.js', array('jquery'), null, true);
	    wp_register_script('dwd-particles-start', plugin_dir_url( __FILE__ ) . 'js/particles-start.js', array('dwd-particles'), null, true);
	    wp_register_script('dwd-animated-bg', plugin_dir_url( __FILE__ ) . 'js/animated-bg.js', array('jquery'), null, true);
	    wp_register_script('dwd-animated-transparent-bg', plugin_dir_url( __FILE__ ) . 'js/animated-transparent-bg.js', array('jquery'), null, true);
	    wp_register_script('dwd-textgif', plugin_dir_url( __FILE__ ) . 'js/textHoler.js', array('jquery'), null, true);
	    wp_register_script('dwd-textgif-start', plugin_dir_url( __FILE__ ) . 'js/textgif-start.js', array('dwd-textgif'), null, true);
	    wp_register_script('dwd-tweenlite', plugin_dir_url( __FILE__ ) . 'js/TweenLite.min.js', array('jquery'), null, true);
	    wp_register_script('dwd-movingnodes', plugin_dir_url( __FILE__ ) . 'js/movingnodes.js', array('dwd-tweenlite'), null, true);
	    wp_register_script('dwd-hover-button-js', plugin_dir_url( __FILE__ ) . 'js/hover-btn.js', array('jquery'), null, true);
	    wp_register_script('dwd-magnific-popup-start', plugin_dir_url( __FILE__ ) . 'js/magnific-popup-start.js', array('jquery'), null, true);
	    wp_register_script('dwd-popup-start', plugin_dir_url( __FILE__ ) . 'js/popup-start.js', array('jquery'), null, true);
	    wp_register_script('dwd-tweenmax', plugin_dir_url( __FILE__ ) . 'js/TweenMax.min.js', array('jquery'), null, true);
	    wp_register_script('dwd-scrollmagic', plugin_dir_url( __FILE__ ) . 'js/ScrollMagic.min.js', array('jquery'), null, true);
	    wp_register_script('dwd-scroll-fading', plugin_dir_url( __FILE__ ) . 'js/scrolling-fading.js', array('jquery'), null, true);
	    wp_register_script('dwd-animation-gsap', plugin_dir_url( __FILE__ ) . 'js/animation.gsap.js', array('jquery'), null, true);
	    wp_register_script('dwd-shuffle-letter', plugin_dir_url( __FILE__ ) . 'js/jquery.shuffleLetters.js', array('jquery'), null, true);
	    wp_register_script('dwd-shuffle-start', plugin_dir_url( __FILE__ ) . 'js/shuffle-start.js', array('dwd-shuffle-letter'), null, true);
	    wp_register_script('dwd-interactive-bg', plugin_dir_url( __FILE__ ) . 'js/interactive-bg.js', array('dwd-tweenmax'), null, true);
	    wp_register_script('dwd-slicey-blurry', plugin_dir_url( __FILE__ ) . 'js/slicey-blurry.js', array('dwd-tweenmax'), null, true);
	    wp_register_script('dwd-wave-effect', plugin_dir_url( __FILE__ ) . 'js/jquery.wavify.js', array('jquery'), null, true);
	}

}
